
// PTUWeather
//
// Giles Harrison Jan 2020

// simple PTU display program for an Arduino Nano connected to a BME280 sensor and SSD1306 LCD 


// reads in P,T,U from sensor
// formats and rounds integer values for display, to resemble floating point values
// outputs data values over serial link to computer at 9600 baud


// uses TinyBME280 library (of David Johnson-Davies) at http://www.technoblogy.com/list?2F9I   
   //Licensed under a Creative Commons Attribution 4.0 International license: 
   //http://creativecommons.org/licenses/by/4.0/
//


// uses Adafruit library for the LCD 
// available at https://github.com/adafruit/Adafruit_SSD1306
/**************************************************************************
 This is an example for our Monochrome OLEDs based on SSD1306 drivers

 Pick one up today in the adafruit shop!
 ------> http://www.adafruit.com/category/63_98

 This example is for a 128x32 pixel display using I2C to communicate
 3 pins are required to interface (two I2C and one reset).

 Adafruit invests time and resources providing this open
 source code, please support Adafruit and open-source
 hardware by purchasing products from Adafruit!

 Written by Limor Fried/Ladyada for Adafruit Industries,
 with contributions from the open source community.
 BSD license, check license.txt for more information
 All text above, and the splash screen below must be
 included in any redistribution.
 **************************************************************************/




// standard libraries

#include <SPI.h>
#include <Wire.h>



// lcd libraries
// #include <Adafruit_GFX.h>
#include <Adafruit_SSD1306.h>

#define SCREEN_WIDTH 128 // OLED display width, in pixels
#define SCREEN_HEIGHT 32 // OLED display height, in pixels

// Declaration for an SSD1306 display connected to I2C (SDA, SCL pins)
#define OLED_RESET     4 // Reset pin # (or -1 if sharing Arduino reset pin)
Adafruit_SSD1306 display(SCREEN_WIDTH, SCREEN_HEIGHT, &Wire, OLED_RESET);



// sensor libraries
#include <TinyBME280.h>



// program global variables
long TT;                  // temperature 
long TT2;
unsigned long PP;
unsigned long UU;
byte TTF;
byte UUPC;
String St;
long count;



void setup() {
  count=0;  // sample counter
  
  // open serial connection for viewing
  Serial.begin(9600);
  Serial.print("count P T U");
  Serial.println();

  // SSD1306_SWITCHCAPVCC = generate display voltage from 3.3V internally
  if(!display.begin(SSD1306_SWITCHCAPVCC, 0x3C)) { // Address 0x3C for 128x32
    Serial.println(F("SSD1306 allocation failed"));
    for(;;); // Don't proceed, loop forever
  }

  // Show initial display buffer contents on the screen --
  // the library initializes this with an Adafruit splash screen.
  display.display();
  delay(2000); // Pause for 2 seconds

  // Clear the buffer
  display.clearDisplay();

  // Draw a single pixel in white
  display.drawPixel(10, 10, SSD1306_WHITE);

  // Show the display buffer on the screen. You MUST call display() after
  // drawing commands to make them visible on screen!
  display.display();
  delay(1000);
  // display.display() is NOT necessary after every single drawing command,
  // unless that's what you want...rather, you can batch up a bunch of
  // drawing operations and then update the screen all at once by calling
  // display.display(). These examples demonstrate both approaches...

  // Set up BME280 sensor
  Wire.begin();
  BME280setI2Caddress(0x76);
  BME280setup();

}




// code for moving digits around and making strings of integers to look like floating point values
//...............................


byte CountDigits(long Number){
  // counts the number of digits in Number
  long t1;
  long t2;  
  byte Ndigs;

t2=1;
t1=1;
Ndigs=0;

while (t1!=0){
Ndigs++;
t2=t2*10;
t1=Number/t2;  
}

return Ndigs;  
}


long TentoTheX(byte x){
// simple antilog code
long t;
t=1;
for (byte i=0; i<x; i++){
t=t*10;
}
return t;
}



byte Digit(long Number, byte digitno){
  // returns a particular digit, counting the positions from right to left in a number
  // find power of ten for the digit sought, divide input number by that value, and then modulus the quotient with ten
  long t1;
  long t2;  
t1=1;
t2=1;

t2=TentoTheX(digitno)/10;
t1 = (Number / t2) % 10;
return t1;  
}

long TruncateNumber(long Number, byte Lengthdigs){
  // code to shorten Number to contain the first (Lengthdigs) of digits
long mult;
byte Ndigits;
byte Ndigs;
long NumShort;
byte RD;
Ndigits=CountDigits(Number);
if (Lengthdigs>=Ndigits)
{
NumShort=Number;
goto finish;
}

// extract the digits to round
Ndigs=Ndigits-Lengthdigs;
mult=TentoTheX(Ndigs);
NumShort=Number/mult;

// use the next most significant digit to possibly increase the value by 1 (ie rounding)
RD=Digit(Number,Ndigs);
if (RD>=5)
{NumShort=NumShort+1;}

finish:
return NumShort;
}



String DisplayIntegerAsFP(long Number, byte Npredigits, byte Ndecimals){
 // splits up a long variable (Number) to give Ndigits before the decimal point and Ndecimals after
 // decimal point added and a string returned
String DPright(10);
String DPleft(10);
String sign(1);
String result;
long dd1;
long dd2;
long tleft;
long tright;
long NumR;
byte Ndigits;

if (Number<=0)
{sign="-";}
else
{sign="";}

Number=abs(Number);
NumR=TruncateNumber(Number,Npredigits+Ndecimals);
Ndigits=CountDigits(NumR);

// separate off the integer part left of the DP
dd1=Ndigits-Npredigits;


dd2=TentoTheX(dd1);
tleft=NumR/dd2;
DPleft=String(tleft);

// and the decimal part
tright=NumR-(tleft*dd2);
tright=abs(tright);
DPright=String(tright);

// stick these bits together with a decimal point
if (Ndecimals==0)
{result=sign+DPleft;}
else
{result=sign+DPleft+'.'+DPright;}

return result;  
}

//...............................






// main code to provide data values, format them and display them
void loop() {

  count++;    // increment sample counter
  
  display.clearDisplay();
  display.setTextSize(1); 
  display.setTextColor(SSD1306_WHITE);
  display.setCursor(0, 0);
  
  // retrieve values from sensor
  TT=BME280temperature();
  PP=BME280pressure();
  UU=BME280humidity();

  // format pressure sensor values
  if (PP<100000)
  {St=DisplayIntegerAsFP(PP,3,2);}  
  else  
  St=DisplayIntegerAsFP(PP,4,2);
  display.print(St);     
  display.println(" hPa");     
 
  // format temperature values
  if (TT<0) // add a minus sign
  {TT2=abs(TT);
    St=DisplayIntegerAsFP(TT2,2,1);
    St=St+"-";
  }
  else
  {St=DisplayIntegerAsFP(TT,2,1);}
  display.print(St);     
  display.println(" degC");     
 
  // format humidity values
  St=DisplayIntegerAsFP(UU,2,1);
  display.print(St);     
  display.println(" %");     
  display.display();
  delay(1000);  // 1 sample per second


  // write values over serial link as: sample number, pressure, temperature, RH
  // pressure in Pa
  // temperature in Celsius x100
  // RH in % x 100
  Serial.print(count);
  Serial.print(" ");
  Serial.print(PP);
  Serial.print(" ");
  Serial.print(TT);
  Serial.print(" ");  
  Serial.print(UU);
  Serial.println();

}
